//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import "RFCommands.h"

#import <UIKit/UIKit.h>


@implementation NSObject (RFCommands)



/*---------------------- GENERAL COMMANDS ----------------------*/

NSString * const cmd_readTagConfig = @"12C03701";
NSString * const cmd_readTagConfigReg = @"12C0A101";
NSString * const cmd_readTagStatus = @"12C0A001";
NSString * const cmd_writeTagConfig = @"12C137";
NSString * const cmd_writeTagConfigSession = @"12C1A1";
NSString * const cmd_activateI2CSlave = @"12C13700020F00";
NSString * const cmd_readI2cAddr = @"12C03E01";
NSString * const cmd_activateI2CMaster = @"12C13700120F02";
NSString * const cmd_activateGPIOPWM = @"12C13700220F00";
NSString * const cmd_readGPIOPWMConfig = @"12C0A301";
NSString * const cmd_readSRAM = @"12D2013F";

/*---------------------- GPIO COMMANDS ----------------------*/

NSString * const cmd_writeGPIOConfig = @"12C13908000000";
NSString * const cmd_writeGPIOSession = @"12C1A308000000";
NSString * const cmd_gpioSetSessionOutput = @"12C1A348000000";
NSString * const cmd_gpioClearSessionOutput = @"12C1A308000000";

/*---------------------- PWM COMMANDS ----------------------*/

NSString * const cmd_readPWM0Reg = @"12C0A401";
NSString * const cmd_readPWM1Reg  = @"12C0A501";
NSString * const cmd_writePWMSession = @"12C1A3";
NSString * const cmd_writePWM0Reg = @"12C1A4";
NSString * const cmd_writePWM1Reg = @"12C1A5";

/*---------------------- PASSTHROUGH COMMANDS ----------------------*/

NSString *const cmd_writeSRAM = @"02D3043B";

/*---------------------- I2C MASTER COMMANDS ----------------------*/

NSString * const cmd_readI2CMasterCommand = @"12D51F00";
NSString * const cmd_GetTempI2CMasterCommand = @"12D49F0051";
NSString * const cmd_GetXaccMSBI2CMasterCommand = @"12D49F0001";
NSString * const cmd_GetYaccMSBI2CMasterCommand = @"12D49F0003";
NSString * const cmd_GetZaccMSBI2CMasterCommand = @"12D49F0005";
NSString * const cmd_GetXmagMSBI2CMasterCommand = @"12D49F0033";
NSString * const cmd_GetYmagMSBI2CMasterCommand = @"12D49F0035";
NSString * const cmd_GetZmagMSBI2CMasterCommand = @"12D49F0037";
NSString * const cmd_setHybridModeI2CMasterCommand = @"12D41F015B1F";
NSString * const cmd_setStandByModeI2CMasterCommand = @"12D41F012A00";
NSString * const cmd_setControlReg2I2CMasterCommand = @"12D41F015C20";
NSString * const cmd_setActiveModeI2CMasterCommand = @"12D41F012A0D";
NSString * const cmd_i2cMasterConfigStatus = @"12C0AD01";
NSString * const cmd_readSRAMI2CMaster = @"12D20006";

/*---------------------- ALM COMMANDS ----------------------*/

NSString * const cmd_readALMConfiguration = @"12C04001";


@end
